﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Web.Profile;

namespace ApplicationServicesDemo
{
public class UserProfile : ProfileBase
{
    public static UserProfile GetUserProfile()
    {
        return Create(Membership.GetUser().UserName) as UserProfile;
    }
    
    [SettingsAllowAnonymous(false)]
    public string FavoriteColor
    {
        get { return base["FavoriteColor"] as string; }
        set { base["FavoriteColor"] = value; } 
    }
    [SettingsAllowAnonymous(false)]
    public string PetsName 
    {
        get { return base["PetsName"] as string; }
        set { base["PetsName"] = value; }
    }
    [SettingsAllowAnonymous(false)]
    public HomePageSettings HomePageSettings
    {
        get 
        {
            HomePageSettings pageSettings = base["HomePageSettings"] as HomePageSettings;
            if (pageSettings == null)
            {
                pageSettings = new HomePageSettings();
                base["HomePageSettings"] = pageSettings;
            }
            return pageSettings;
        }
        set { base["HomePageSettings"] = value; }
    }
}

public class HomePageSettings
{
    public string News { get; set; }
    public string Weather { get; set; }
    public string Sports { get; set; }
}
}
